/*****************************************************************************************************************************
 ***  This program creates the user-defined formats for the 2017-18 Private School Survey (PSS) public-use data file.      ***
 ***                                                                                                                       ***
 ***  NOTE: You will have to change the LIBNAME assignment below to match the location of your data.                       ***
 ***                                                                                                                       ***
 ***  PROGRAM: Create PU 2017-18 PSS SAS Formats.sas                                                                       ***
 ***  AUTHOR:  National Center for Education Statistics                                                                    ***
 ***  DATE:    July 19, 2019                                                                                               ***
 *****************************************************************************************************************************/

/* Specify location of SAS Format catalog */
libname library 'C:\NCES\PSS\2017-18\Data';

/* Create user-defined formats and save permanently */
proc format library=library;
   value CSOURCEF 1 = 'Mail'
            2 = 'Internet'
            3 = 'Regional Office follow-up'
            4 = 'CATI (computer-assisted telephone interview)';
   value DIOCESEF 101 = 'Diocese of Birmingham, AL'
            102 = 'Diocese of Mobile, AL'
            201 = 'Archdiocese of Anchorage, AK'
            202 = 'Diocese of Fairbanks, AK'
            203 = 'Diocese of Juneau, AK'
            401 = 'Diocese of Phoenix, AZ'
            402 = 'Diocese of Tucson, AZ'
            501 = 'Diocese of Little Rock, AR'
            601 = 'Archdiocese of Los Angeles, CA'
            602 = 'Archdiocese of San Francisco, CA'
            603 = 'Diocese of Fresno, CA'
            604 = 'Diocese of Monterey, CA'
            605 = 'Diocese of Oakland, CA'
            606 = 'Diocese of Orange, CA'
            607 = 'Diocese of Sacramento, CA'
            608 = 'Diocese of San Bernardino, CA'
            609 = 'Diocese of San Diego, CA'
            610 = 'Diocese of San Jose, CA'
            611 = 'Diocese of Santa Rosa, CA'
            612 = 'Diocese of Stockton, CA'
            801 = 'Archdiocese of Denver, CO'
            802 = 'Diocese of Colorado Springs, CO'
            803 = 'Diocese of Pueblo, CO'
            901 = 'Archdiocese of Hartford, CT'
            902 = 'Diocese of Bridgeport, CT'
            903 = 'Diocese of Norwich, CT'
            1001 = 'Diocese of Wilmington, DE'
            1101 = 'Archdiocese of Washington, DC'
            1201 = 'Archdiocese of Miami, FL'
            1202 = 'Diocese of Pensacola-Tallahassee, FL'
            1203 = 'Diocese of Orlando, FL'
            1204 = 'Diocese of Palm Beach, FL'
            1205 = 'Diocese of St. Augustine, FL'
            1206 = 'Diocese of St. Petersburg, FL'
            1207 = 'Diocese of Venice, FL'
            1301 = 'Archdiocese of Atlanta, GA'
            1302 = 'Diocese of Savannah, GA'
            1501 = 'Diocese of Honolulu, HI'
            1601 = 'Diocese of Boise, ID'
            1701 = 'Archdiocese of Chicago, IL'
            1702 = 'Diocese of Belleville, IL'
            1703 = 'Diocese of Joliet, IL'
            1704 = 'Diocese of Peoria, IL'
            1705 = 'Diocese of Rockford, IL'
            1706 = 'Diocese of Springfield, IL'
            1801 = 'Archdiocese of Indianapolis, IN'
            1802 = 'Diocese of Evansville, IN'
            1803 = 'Diocese of Ft. Wayne-South Bend, IN'
            1804 = 'Diocese of Gary, IN'
            1805 = 'Diocese of Lafayette, IN'
            1901 = 'Archdiocese of Dubuque, IA'
            1902 = 'Diocese of Davenport, IA'
            1903 = 'Diocese of Des Moines, IA'
            1904 = 'Diocese of Sioux City, IA'
            2001 = 'Archdiocese of Kansas City, KS'
            2002 = 'Diocese of Dodge City, KS'
            2003 = 'Diocese of Salina, KS'
            2004 = 'Diocese of Wichita, KS'
            2101 = 'Archdiocese of Louisville, KY'
            2102 = 'Diocese of Covington, KY'
            2103 = 'Diocese of Lexington, KY'
            2104 = 'Diocese of Owensboro, KY'
            2201 = 'Archdiocese of New Orleans, LA'
            2202 = 'Diocese of Alexandria, LA'
            2203 = 'Diocese of Baton Rouge, LA'
            2204 = 'Diocese of Houma-Thibodaux, LA'
            2205 = 'Diocese of Lafayette, LA'
            2206 = 'Diocese of Lake Charles, LA'
            2207 = 'Diocese of Shreveport, LA'
            2301 = 'Diocese of Portland, ME'
            2401 = 'Archdiocese of Baltimore, MD'
            2501 = 'Archdiocese of Boston, MA'
            2502 = 'Diocese of Fall River, MA'
            2503 = 'Diocese of Springfield, MA'
            2504 = 'Diocese of Worcester, MA'
            2601 = 'Archdiocese of Detroit, MI'
            2602 = 'Diocese of Grand Rapids, MI'
            2603 = 'Diocese of Gaylord, MI'
            2604 = 'Diocese of Kalamazoo, MI'
            2605 = 'Diocese of Lansing, MI'
            2606 = 'Diocese of Marquette, MI'
            2607 = 'Diocese of Saginaw, MI'
            2701 = 'Archdiocese of St. Paul-Minneapolis, MN'
            2702 = 'Diocese of Crookston, MN'
            2703 = 'Diocese of Duluth, MN'
            2704 = 'Diocese of New Ulm, MN'
            2705 = 'Diocese of St. Cloud, MN'
            2706 = 'Diocese of Winona, MN'
            2801 = 'Diocese of Biloxi, MS'
            2802 = 'Diocese of Jackson, MS'
            2901 = 'Archdiocese of St. Louis, MO'
            2902 = 'Diocese of Jefferson City, MO'
            2903 = 'Diocese of Kansas City-St. Joseph, MO'
            2904 = 'Diocese of Springfield-Cape Girardeau, MO'
            3001 = 'Diocese of Great Falls-Billings, MT'
            3002 = 'Diocese of Helena, MT'
            3101 = 'Archdiocese of Omaha, NE'
            3102 = 'Diocese of Grand Island, NE'
            3103 = 'Diocese of Lincoln, NE'
            3201 = 'Diocese of Las Vegas, NV'
            3202 = 'Diocese of Reno, NV'
            3301 = 'Diocese of Manchester, NH'
            3401 = 'Archdiocese of Newark, NJ'
            3402 = 'Diocese of Camden, NJ'
            3403 = 'Diocese of Metuchen, NJ'
            3404 = 'Diocese of Paterson, NJ'
            3405 = 'Diocese of Trenton, NJ'
            3501 = 'Archdiocese of Santa Fe, NM'
            3502 = 'Diocese of Gallup, NM'
            3503 = 'Diocese of Las Cruces, NM'
            3601 = 'Archdiocese of New York, NY'
            3602 = 'Diocese of Albany, NY'
            3603 = 'Diocese of Brooklyn, NY'
            3604 = 'Diocese of Buffalo, NY'
            3605 = 'Diocese of Ogdensburg, NY'
            3606 = 'Diocese of Rochester, NY'
            3607 = 'Diocese of Rockville Centre, NY'
            3608 = 'Diocese of Syracuse, NY'
            3701 = 'Diocese of Charlotte, NC'
            3702 = 'Diocese of Raleigh, NC'
            3801 = 'Diocese of Bismarck, ND'
            3802 = 'Diocese of Fargo, ND'
            3901 = 'Archdiocese of Cincinnati, OH'
            3902 = 'Diocese of Cleveland, OH'
            3903 = 'Diocese of Columbus, OH'
            3904 = 'Diocese of Steubenville, OH'
            3905 = 'Diocese of Toledo, OH'
            3906 = 'Diocese of Youngstown, OH'
            4001 = 'Archdiocese of Oklahoma City, OK'
            4002 = 'Diocese of Tulsa, OK'
            4101 = 'Archdiocese of Portland, OR'
            4102 = 'Diocese of Baker, OR'
            4201 = 'Archdiocese of Philadelphia, PA'
            4202 = 'Diocese of Allentown, PA'
            4203 = 'Diocese of Altoona-Johnstown, PA'
            4204 = 'Diocese of Erie, PA'
            4205 = 'Diocese of Greensburg, PA'
            4206 = 'Diocese of Harrisburg, PA'
            4207 = 'Diocese of Pittsburgh, PA'
            4208 = 'Diocese of Scranton, PA'
            4401 = 'Diocese of Providence, RI'
            4501 = 'Diocese of Charleston, SC'
            4601 = 'Diocese of Rapid City, SD'
            4602 = 'Diocese of Sioux Falls, SD'
            4701 = 'Diocese of Knoxville, TN'
            4702 = 'Diocese of Memphis, TN'
            4703 = 'Diocese of Nashville, TN'
            4801 = 'Archdiocese of San Antonio, TX'
            4802 = 'Diocese of Amarillo, TX'
            4803 = 'Diocese of Austin, TX'
            4804 = 'Diocese of Beaumont, TX'
            4805 = 'Diocese of Brownsville, TX'
            4806 = 'Diocese of Corpus Christi, TX'
            4807 = 'Diocese of Dallas, TX'
            4808 = 'Diocese of El Paso, TX'
            4809 = 'Diocese of Ft. Worth, TX'
            4810 = 'Diocese of Galveston-Houston, TX'
            4811 = 'Diocese of Lubbock, TX'
            4812 = 'Diocese of San Angelo, TX'
            4813 = 'Diocese of Tyler, TX'
            4814 = 'Diocese of Victoria, TX'
            4815 = 'Diocese of Laredo, TX'
            4901 = 'Diocese of Salt Lake, UT'
            5001 = 'Diocese of Burlington, VT'
            5101 = 'Diocese of Arlington, VA'
            5102 = 'Diocese of Richmond, VA'
            5301 = 'Archdiocese of Seattle, WA'
            5302 = 'Diocese of Spokane, WA'
            5303 = 'Diocese of Yakima, WA'
            5401 = 'Diocese of Wheeling-Charleston, WV'
            5501 = 'Archdiocese of Milwaukee, WI'
            5502 = 'Diocese of Green Bay, WI'
            5503 = 'Diocese of La Crosse, WI'
            5504 = 'Diocese of Madison, WI'
            5505 = 'Diocese of Superior, WI'
            5601 = 'Diocese of Cheyenne, WY'
            . = 'Valid Skip';
   value F_P135F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P140F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P145F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P150F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P155F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P160F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P165F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P170F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P175F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P180F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P185F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P190F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P195F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P200F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P205F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P210F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P215F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P220F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P225F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P230F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P235F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P240F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P245F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P250F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P255F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P260F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P265F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P270F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P275F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P280F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P285F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P290F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P295F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P300F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P305F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P320F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P330F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P325F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P316F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P318F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P310F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P332F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P335F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P340F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P345F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P350F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P360F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P365F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P370F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P385F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P390F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P395F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P400F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P405F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P410F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P415F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P420F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P425F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P430F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P435F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P440F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P445F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P450F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P455F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P460F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P465F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P467F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P468F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P470F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P475F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P480F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P485F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P490F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P492F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P495F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P500F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P505F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P510F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P515F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P520F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P522F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P525F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P530F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P535F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P540F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P542F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P545F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P550F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P555F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P575F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P580F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P585F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P590F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P600F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P602F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P605F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P610F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P620F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P622F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P630F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P635F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P640F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P645F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P650F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P655F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value F_P660F 0 = 'Not imputed (original data)'
            4 = 'Imputed by using a donor value'
            5 = 'Data adjusted by analyst during review';
   value $FRAMEF AREA = 'School is part of area frame'
            LIST = 'School is part of list frame';
   value HIGR2018F 1 = 'All Ungraded'
            2 = 'Highest grade in school is prekindergarten'
            3 = 'Highest grade in school is kindergarten'
            4 = 'Highest grade in school is transitional kindergarten'
            5 = 'Highest grade in school is transitional first grade'
            6 = 'Highest grade in school is 1st grade'
            7 = 'Highest grade in school is 2nd grade'
            8 = 'Highest grade in school is 3rd grade'
            9 = 'Highest grade in school is 4th grade'
            10 = 'Highest grade in school is 5th grade'
            11 = 'Highest grade in school is 6th grade'
            12 = 'Highest grade in school is 7th grade'
            13 = 'Highest grade in school is 8th grade'
            14 = 'Highest grade in school is 9th grade'
            15 = 'Highest grade in school is 10th grade'
            16 = 'Highest grade in school is 11th grade'
            17 = 'Highest grade in school is 12th grade';
   value LEVELF 1 = 'Elementary'
            2 = 'Secondary'
            3 = 'Combined elementary and secondary';
   value LOGR2018F 1 = 'All Ungraded'
            2 = 'Lowest grade in school is prekindergarten'
            3 = 'Lowest grade in school is kindergarten'
            4 = 'Lowest grade in school is transitional kindergarten'
            5 = 'Lowest grade in school is transitional first grade'
            6 = 'Lowest grade in school is 1st grade'
            7 = 'Lowest grade in school is 2nd grade'
            8 = 'Lowest grade in school is 3rd grade'
            9 = 'Lowest grade in school is 4th grade'
            10 = 'Lowest grade in school is 5th grade'
            11 = 'Lowest grade in school is 6th grade'
            12 = 'Lowest grade in school is 7th grade'
            13 = 'Lowest grade in school is 8th grade'
            14 = 'Lowest grade in school is 9th grade'
            15 = 'Lowest grade in school is 10th grade'
            16 = 'Lowest grade in school is 11th grade'
            17 = 'Lowest grade in school is 12th grade';
   value ORIENTF 1 = 'Roman Catholic'
            2 = 'African Methodist Episcopal'
            3 = 'Amish'
            4 = 'Assembly of God'
            5 = 'Baptist'
            6 = 'Brethren'
            7 = 'Calvinist'
            8 = 'Christian (no specific denomination)'
            9 = 'Church of Christ'
            10 = 'Church of God'
            11 = 'Church of God in Christ'
            12 = 'Church of the Nazarene'
            13 = 'Disciples of Christ'
            14 = 'Episcopal'
            15 = 'Friends'
            16 = 'Greek Orthodox'
            17 = 'Islamic'
            18 = 'Jewish'
            19 = 'Latter Day Saints'
            20 = 'Lutheran Church - Missouri Synod'
            21 = 'Evangelical Lutheran Church in America'
            22 = 'Wisconsin Evangelical Lutheran Synod'
            23 = 'Other Lutheran'
            24 = 'Mennonite'
            25 = 'Methodist'
            26 = 'Pentecostal'
            27 = 'Presbyterian'
            28 = 'Seventh-Day Adventist'
            29 = 'Other'
            30 = 'Nonsectarian';
   value P135F 1 = 'Yes'
            2 = 'No';
   value P145F 1 = 'Yes'
            2 = 'No';
   value P155F 1 = 'Yes'
            2 = 'No';
   value P165F 1 = 'Yes'
            2 = 'No';
   value P175F 1 = 'Yes'
            2 = 'No';
   value P185F 1 = 'Yes'
            2 = 'No';
   value P195F 1 = 'Yes'
            2 = 'No';
   value P205F 1 = 'Yes'
            2 = 'No';
   value P215F 1 = 'Yes'
            2 = 'No';
   value P225F 1 = 'Yes'
            2 = 'No';
   value P235F 1 = 'Yes'
            2 = 'No';
   value P245F 1 = 'Yes'
            2 = 'No';
   value P255F 1 = 'Yes'
            2 = 'No';
   value P265F 1 = 'Yes'
            2 = 'No';
   value P275F 1 = 'Yes'
            2 = 'No';
   value P285F 1 = 'Yes'
            2 = 'No';
   value P295F 1 = 'Yes'
            2 = 'No';
   value P335F 1 = 'Yes'
            2 = 'No, it is an all-female school'
            3 = 'No, it is an all-male school';
   value P345F 1 = 'Yes'
            2 = 'No';
   value P365F 0 = 'N/A'
            1 = 'Full day'
            2 = 'Half day'
            3 = 'Both offered';
   value P415F 1 = 'Regular elementary or secondary'
            2 = 'Montessori'
            3 = 'Special program emphasis'
            4 = 'Special education'
            5 = 'Career/technical/vocational'
            6 = 'Alternative/other'
            7 = 'Early childhood program/child care center';
   value P420F 1 = 'Yes'
            2 = 'No';
   value P425F 1 = 'Yes'
            2 = 'No';
   value P430F 1 = 'Yes'
            2 = 'No';
   value P435F 1 = 'Yes'
            2 = 'No'
            . = 'Valid Skip';
   value P440F 1 = 'Roman Catholic'
            2 = 'African Methodist Episcopal'
            3 = 'Amish'
            4 = 'Assembly of God'
            5 = 'Baptist'
            6 = 'Brethren'
            7 = 'Calvinist'
            8 = 'Christian (no specific denomination)'
            9 = 'Church of Christ'
            10 = 'Church of God'
            11 = 'Church of God in Christ'
            12 = 'Church of the Nazarene'
            13 = 'Disciples of Christ'
            14 = 'Episcopal'
            15 = 'Friends'
            16 = 'Greek Orthodox'
            17 = 'Islamic'
            18 = 'Jewish'
            19 = 'Latter Day Saints'
            20 = 'Lutheran Church - Missouri Synod'
            21 = 'Evangelical Lutheran Church in America'
            22 = 'Wisconsin Evangelical Lutheran Synod'
            23 = 'Other Lutheran'
            24 = 'Mennonite'
            25 = 'Methodist'
            26 = 'Pentecostal'
            27 = 'Presbyterian'
            28 = 'Seventh-Day Adventist'
            29 = 'Other'
            . = 'Valid Skip';
   value P445F 1 = 'Parochial'
            2 = 'Diocesan'
            3 = 'Private'
            . = 'Valid Skip';
   value P450F 0 = 'Does belong to an organization/association'
            1 = 'Does not belong to an organization/association';
   value P455F 0 = 'Not member'
            1 = 'Member';
   value P460F 0 = 'Not member'
            1 = 'Member';
   value P465F 0 = 'Not member'
            1 = 'Member';
   value P467F 0 = 'Not member'
            1 = 'Member';
   value P468F 0 = 'Not member'
            1 = 'Member';
   value P470F 0 = 'Not member'
            1 = 'Member';
   value P475F 0 = 'Not member'
            1 = 'Member';
   value P480F 0 = 'Not member'
            1 = 'Member';
   value P485F 0 = 'Not member'
            1 = 'Member';
   value P490F 0 = 'Not member'
            1 = 'Member';
   value P492F 0 = 'Not member'
            1 = 'Member';
   value P495F 0 = 'Not member'
            1 = 'Member';
   value P500F 0 = 'Not member'
            1 = 'Member';
   value P505F 0 = 'Not member'
            1 = 'Member';
   value P510F 0 = 'Not member'
            1 = 'Member';
   value P515F 0 = 'Not member'
            1 = 'Member';
   value P520F 0 = 'Not member'
            1 = 'Member';
   value P522F 0 = 'Not member'
            1 = 'Member';
   value P525F 0 = 'Not member'
            1 = 'Member';
   value P530F 0 = 'Not member'
            1 = 'Member';
   value P535F 0 = 'Not member'
            1 = 'Member';
   value P540F 0 = 'Not member'
            1 = 'Member';
   value P542F 0 = 'Not member'
            1 = 'Member';
   value P545F 0 = 'Not member'
            1 = 'Member';
   value P550F 0 = 'Not member'
            1 = 'Member';
   value P555F 0 = 'Not member'
            1 = 'Member';
   value P575F 0 = 'Not member'
            1 = 'Member';
   value P580F 0 = 'Not member'
            1 = 'Member';
   value P585F 0 = 'Not member'
            1 = 'Member';
   value P590F 0 = 'Not member'
            1 = 'Member';
   value P600F 0 = 'Not member'
            1 = 'Member';
   value P602F 0 = 'Not member'
            1 = 'Member';
   value P605F 0 = 'Not member'
            1 = 'Member';
   value P610F 0 = 'Not member'
            1 = 'Member';
   value P620F 0 = 'Not member'
            1 = 'Member';
   value P622F 0 = 'Not member'
            1 = 'Member';
   value P630F 0 = 'Not member'
            1 = 'Member';
   value P635F 0 = 'Not member'
            1 = 'Member';
   value P640F 0 = 'Not member'
            1 = 'Member';
   value P660F 1 = 'Yes'
            2 = 'No';
   value PSTANSIF 1 = 'Alabama'
            2 = 'Alaska'
            4 = 'Arizona'
            5 = 'Arkansas'
            6 = 'California'
            8 = 'Colorado'
            9 = 'Connecticut'
            10 = 'Delaware'
            11 = 'District of Columbia'
            12 = 'Florida'
            13 = 'Georgia'
            15 = 'Hawaii'
            16 = 'Idaho'
            17 = 'Illinois'
            18 = 'Indiana'
            19 = 'Iowa'
            20 = 'Kansas'
            21 = 'Kentucky'
            22 = 'Louisiana'
            23 = 'Maine'
            24 = 'Maryland'
            25 = 'Massachusetts'
            26 = 'Michigan'
            27 = 'Minnesota'
            28 = 'Mississippi'
            29 = 'Missouri'
            30 = 'Montana'
            31 = 'Nebraska'
            32 = 'Nevada'
            33 = 'New Hampshire'
            34 = 'New Jersey'
            35 = 'New Mexico'
            36 = 'New York'
            37 = 'North Carolina'
            38 = 'North Dakota'
            39 = 'Ohio'
            40 = 'Oklahoma'
            41 = 'Oregon'
            42 = 'Pennsylvania'
            44 = 'Rhode Island'
            45 = 'South Carolina'
            46 = 'South Dakota'
            47 = 'Tennessee'
            48 = 'Texas'
            49 = 'Utah'
            50 = 'Vermont'
            51 = 'Virginia'
            53 = 'Washington'
            54 = 'West Virginia'
            55 = 'Wisconsin'
            56 = 'Wyoming';
   value REGIONF 1 = 'Northeast'
            2 = 'Midwest'
            3 = 'South'
            4 = 'West';
   value RELIGF 1 = 'Catholic  (P430=1 and P440=1)'
            2 = 'Other religious  (P430=1 and P440 ne 1)'
            3 = 'Nonsectarian  (P430=2)';
   value SIZEF 1 = 'Less than 50 students'
            2 = '50-149 students'
            3 = '150-299 students'
            4 = '300-499 students'
            5 = '500-749 students'
            6 = '750 students or more';
   value TABFLAGF 1 = 'Schools offering ungraded or grade 1 or above'
            2 = 'Schools offering no grade higher than KG';
   value TYPOLOGYF 1 = 'Catholic, parochial'
            2 = 'Catholic, diocesan'
            3 = 'Catholic, private'
            4 = 'Other religious, conservative Christian'
            5 = 'Other relig., affiliated w/ established denomination'
            6 = 'Other relig., not affiliated w/ any denomination'
            7 = 'Nonsectarian, regular school'
            8 = 'Nonsectarian, special program'
            9 = 'Nonsectarian, special education';
   value UCOMMTYPF 1 = 'City   (ULOCALE18 = 11, 12, 13)'
            2 = 'Suburb  (ULOCALE18= 21, 22, 23)'
            3 = 'Town  (ULOCALE18= 31, 32, 33)'
            4 = 'Rural  (ULOCALE18 = 41, 42, 43)';
   value ULOCALE18F 11 = 'City, Large'
            12 = 'City, Midsize'
            13 = 'City, Small'
            21 = 'Suburb, Large'
            22 = 'Suburb, Midsize'
            23 = 'Suburb, Small'
            31 = 'Town, Fringe'
            32 = 'Town, Distant'
            33 = 'Town, Remote'
            41 = 'Rural, Fringe'
            42 = 'Rural, Distant'
            43 = 'Rural, Remote';
run;